/*
 * This class takes a schedule and exports
 * an Excell spreadsheet in XML format
 */

package creeksidescheduler;


public class ExcelXML {

    String text,header,docProps,workBook,styles,workSheet,table,wsOptions,wsTail,tail;
    boolean generating=false;

    public ExcelXML(){

        header="<?xml version=\"1.0\"?>\n" +
                "<Workbook xmlns=\"urn:schemas-microsoft-com:office:spreadsheet\"\n" +
                "\txmlns:o=\"urn:schemas-microsoft-com:office:office\"\n"+
                "\txmlns:x=\"urn:schemas-microsoft-com:office:excel\"\n" +
                "\txmlns:ss=\"urn:schemas-microsoft-com:office:spreadsheet\"\n" +
                "\txmlns:html=\"http://www.w3.org/TR/REC-html40\">\"\n";
        docProps="\t<DocumentProperties xmlns=\"urn:schemas-microsoft-com:office:office\">\n" +
                "\t\t<Author>Creekside Scheduler</Author>\n" +
                "\t\t<LastAuthor>Bruce Templeton</LastAuthor>\n" +
                "\t\t<Created>2010-05-01T23:04:04Z</Created>\n" +
                "\t\t<Company>Templeton Programming</Company>\n" +
                "\t\t<Version>12.0</Version>\n" +
                "\t</DocumentProperties>\n"+
                "\t<OfficeDocumentSettings xmlns=\"urn:schemas-microsoft-com:office:office\">\n" +
                "\t\t<AllowPNG/>\n" +
                "\t</OfficeDocumentSettings>\n";
        workBook="\t<ExcelWorkbook xmlns=\"urn:schemas-microsoft-com:office:excel\">\n" +
                "\t\t<WindowHeight>15000</WindowHeight>\n" +
                "\t\t<WindowWidth>20000</WindowWidth>\n" +
                "\t\t<WindowTopX>120</WindowTopX>\n" +
                "\t\t<WindowTopY>20</WindowTopY>\n" +
                "\t\t<ProtectStructure>False</ProtectStructure>\n" +
                "\t\t<ProtectWindows>False</ProtectWindows>\n" +
                "\t</ExcelWorkbook>\n";
        styles="\t<Styles>\n" +
                "\t\t<Style ss:ID=\"Default\" ss:Name=\"Normal\">\n" +
                "\t\t\t<Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Bottom\"/>\n" +
                "\t\t\t<Borders />\n" +
                "\t\t\t<Font />\n" +
                "\t\t\t<Interior />\n" +
                "\t\t\t<NumberFormat />\n" +
                "\t\t\t<Protection />\n" +
                "\t\t</Style>\n" +
                "\t</Styles>\n";
        workSheet="\t<Worksheet ss:Name=\"Empty\">\n";
        table="\t\t<Table ss:ExpandedColumnCount=\"2\" ss:ExpandedRowCount=\"5\"\n" +
                "\t\t\tx:FullColumns=\"1\" x:FullRows=\"1\">\n" +
                "\t\t\t<Row>\n" +
                "\t\t\t\t<Cell>\n" +
                "\t\t\t\t\t<Data ss:Type=\"String\">Text in cell A1</Data>\n" +
                "\t\t\t\t</Cell>\n" +
                "\t\t\t</Row>\n" +
                "\t\t</Table>\n";
        wsOptions="\t\t<WorksheetOptions xmlns=\"urn:schemas-microsoft-com:office:excel\">\n" +
                "\t\t\t<Print>\n" +
                "\t\t\t\t<ValidPrinterInfo />\n" +
                "\t\t\t\t<HorizontalResolution>600</HorizontalResolution>\n" +
                "\t\t\t\t<VerticalResolution>600</VerticalResolution>\n" +
                "\t\t\t<Unsynced/>"+
                "\t\t\t</Print>\n" +
                "\t\t\t<PageLayoutZoom>0</PageLayoutZoom>"+
                "\t\t\t<Selected />\n" +
                "\t\t\t<Panes>\n" +
                "\t\t\t\t<Pane>\n" +
                "\t\t\t\t\t<Number>3</Number>\n" +
                "\t\t\t\t\t<ActiveRow>5</ActiveRow>\n" +
                "\t\t\t\t\t<ActiveCol>1</ActiveCol>\n" +
                "\t\t\t\t</Pane>\n" +
                "\t\t\t</Panes>\n" +
                "\t\t\t<ProtectObjects>False</ProtectObjects>\n" +
                "\t\t\t<ProtectScenarios>False</ProtectScenarios>\n" +
                "\t\t</WorksheetOptions>\n";
        wsTail="\t</Worksheet>\n";
        tail="</Workbook>";
        text=header+docProps+workBook+styles+workSheet+table+wsOptions+wsTail+tail;
    }

    public void startGenerate(){
        generating=true;
        workSheet="";
    }

    public void endGenerate(){
        generating=false;
        text=header+docProps+workBook+styles+workSheet+tail;
    }

    public String printXML(){
        return text;
    }

    public void createWorkSheet(Object[][] objTable, Classroom room){
        //create the sheet name
        workSheet=workSheet+"\t<Worksheet ss:Name=\""+room.getName()+"\">\n";
        //creat the table
        //created the header row
        table="\t\t<Table ss:ExpandedColumnCount=\""+Integer.toString(1+objTable[0].length)+"\" ss:ExpandedRowCount=\""+Integer.toString(1+objTable.length)+"\" x:FullColumns=\"1\"\n" +
                "\t\t\tx:FullRows=\"1\"> ss:DefaultColumnWidth=\"65.0\" ss:DefaultRowHeight=\"12.0\">\n"+
                "\t\t\t<Row ss:AutoFitHeight=\"0\">\n" +
                "\t\t\t\t<Cell><Data ss:Type=\"String\">Time</Data></Cell>\n" +
                "\t\t\t\t<Cell><Data ss:Type=\"String\">Monday</Data></Cell>\n" +
                "\t\t\t\t<Cell><Data ss:Type=\"String\">Tuesday</Data></Cell>\n" +
                "\t\t\t\t<Cell><Data ss:Type=\"String\">Wednesday</Data></Cell>\n" +
                "\t\t\t\t<Cell><Data ss:Type=\"String\">Thursday</Data></Cell>\n" +
                "\t\t\t\t<Cell><Data ss:Type=\"String\">Friday</Data></Cell>\n" +
                "\t\t\t</Row>\n";
        //add in the schedule info
        for (int T=0;T<objTable.length;T++){
            //new row
            table=table+"\t\t\t<Row ss:AutoFitHeight=\"0\">\n";
            for (int D=0;D<objTable[0].length;D++){
                //create cells
                table=table+"\t\t\t\t<Cell><Data ss:Type=\"String\">"+(String)objTable[T][D]+"</Data></Cell>\n";
            }
            //finish row
            table=table+"\t\t\t</Row>\n";
        }
        table=table+"\t\t</Table>\n";
        workSheet=workSheet+table+wsOptions+wsTail;
    }

}
